/**
* \file: AilAudioIn.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPLay
*
* \author: J. Michalik / ADIT/SW2 / jmichalik@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_AILAUDIOIN_H
#define CARPLAY_AILAUDIOIN_H

#include <carplay_plugin.h>

namespace adit { namespace carplay
{

class AilAudioIn : public IAudioInAdapter
{

public:
    AilAudioIn();
    virtual ~AilAudioIn();

    // IAudioInAdapter implementation
    // no thread-safety required
public:
    virtual bool Initialize(const IConfiguration& inConfig, IAudioInSink& inSink);
    virtual bool Prepare(AudioFormatStruct inFormat, const std::string& inAudioType);
    virtual bool Start();
    virtual void Stop();

    // private section
private:
    class Impl;
    Impl* impl;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_AILAUDIOIN_H */
